/* a_out_stab.h,v 1.2 2004/09/14 22:27:31 bird Exp */
/** @file
 * GNU, -liberty.
 */

/* Table of DBX symbol codes for the GNU system.
   Copyright 1988, 1991, 1992, 1993, 1994, 1996, 1998
   Free Software Foundation, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */


#ifndef __GNU_STAB__

/* Indicate the GNU stab.h is in use.  */

#define __GNU_STAB__

#define __define_stab(NAME, CODE, STRING) NAME=CODE,
#define __define_stab_duplicate(NAME, CODE, STRING) NAME=CODE,

enum __stab_debug_code
{

/* New stab from Solaris 2.  This uses an n_type of 0, which in a.out files
   overlaps the N_UNDF used for ordinary symbols.  In ELF files, the
   debug information is in a different file section, so there is no conflict.
   This symbol's n_value gives the size of the string section associated
   with this file.  The symbol's n_strx (relative to the just-updated
   string section start address) gives the name of the source file,
   e.g. "foo.c", without any path information.  The symbol's n_desc gives
   the count of upcoming symbols associated with this file (not including
   this one).  */
/* __define_stab (N_UNDF, 0x00, "UNDF")  */

/* Global variable.  Only the name is significant.
   To find the address, look in the corresponding external symbol.  */
__define_stab (N_GSYM, 0x20, "GSYM")

/* Function name for BSD Fortran.  Only the name is significant.
   To find the address, look in the corresponding external symbol.  */
__define_stab (N_FNAME, 0x22, "FNAME")

/* Function name or text-segment variable for C.  Value is its address.
   Desc is supposedly starting line number, but GCC doesn't set it
   and DBX seems not to miss it.  */
__define_stab (N_FUN, 0x24, "FUN")

/* Data-segment variable with internal linkage.  Value is its address.
   "Static Sym".  */
__define_stab (N_STSYM, 0x26, "STSYM")

/* BSS-segment variable with internal linkage.  Value is its address.  */
__define_stab (N_LCSYM, 0x28, "LCSYM")

/* Name of main routine.  Only the name is significant.  */
__define_stab (N_MAIN, 0x2a, "MAIN")

/* Solaris2:  Read-only data symbols.  */
__define_stab (N_ROSYM, 0x2c, "ROSYM")

/* Global symbol in Pascal.
   Supposedly the value is its line number; I'm skeptical.  */
__define_stab (N_PC, 0x30, "PC")

/* Number of symbols:  0, files,,funcs,lines according to Ultrix V4.0. */
__define_stab (N_NSYMS, 0x32, "NSYMS")

/* "No DST map for sym: name, ,0,type,ignored"  according to Ultrix V4.0. */
__define_stab (N_NOMAP, 0x34, "NOMAP")

/* New stab from Solaris 2.  Like N_SO, but for the object file.  Two in
   a row provide the build directory and the relative path of the .o from it.
   Solaris2 uses this to avoid putting the stabs info into the linked
   executable; this stab goes into the ".stab.index" section, and the debugger
   reads the real stabs directly from the .o files instead.  */
__define_stab (N_OBJ, 0x38, "OBJ")

/* New stab from Solaris 2.  Options for the debugger, related to the
   source language for this module.  E.g. whether to use ANSI
   integral promotions or traditional integral promotions.  */
__define_stab (N_OPT, 0x3c, "OPT")

/* Register variable.  Value is number of register.  */
__define_stab (N_RSYM, 0x40, "RSYM")

/* Modula-2 compilation unit.  Can someone say what info it contains?  */
__define_stab (N_M2C, 0x42, "M2C")

/* Line number in text segment.  Desc is the line number;
   value is corresponding address.  On Solaris2, the line number is
   relative to the start of the current function.  */
__define_stab (N_SLINE, 0x44, "SLINE")

/* Similar, for data segment.  */
__define_stab (N_DSLINE, 0x46, "DSLINE")

/* Similar, for bss segment.  */
__define_stab (N_BSLINE, 0x48, "BSLINE")

/* Sun's source-code browser stabs.  ?? Don't know what the fields are.
   Supposedly the field is "path to associated .cb file".  THIS VALUE
   OVERLAPS WITH N_BSLINE!  */
__define_stab_duplicate (N_BROWS, 0x48, "BROWS")

/* GNU Modula-2 definition module dependency.  Value is the modification time
   of the definition file.  Other is non-zero if it is imported with the
   GNU M2 keyword %INITIALIZE.  Perhaps N_M2C can be used if there
   are enough empty fields? */
__define_stab(N_DEFD, 0x4a, "DEFD")

/* New in Solaris2.  Function start/body/end line numbers.  */
__define_stab(N_FLINE, 0x4C, "FLINE")

/* THE FOLLOWING TWO STAB VALUES CONFLICT.  Happily, one is for Modula-2
   and one is for C++.   Still,... */
/* GNU C++ exception variable.  Name is variable name.  */
__define_stab (N_EHDECL, 0x50, "EHDECL")
/* Modula2 info "for imc":  name,,0,0,0  according to Ultrix V4.0.  */
__define_stab_duplicate (N_MOD2, 0x50, "MOD2")

/* GNU C++ `catch' clause.  Value is its address.  Desc is nonzero if
   this entry is immediately followed by a CAUGHT stab saying what exception
   was caught.  Multiple CAUGHT stabs means that multiple exceptions
   can be caught here.  If Desc is 0, it means all exceptions are caught
   here.  */
__define_stab (N_CATCH, 0x54, "CATCH")

/* Structure or union element.  Value is offset in the structure.  */
__define_stab (N_SSYM, 0x60, "SSYM")

/* Solaris2:  Last stab emitted for module.  */
__define_stab (N_ENDM, 0x62, "ENDM")

/* Name of main source file.
   Value is starting text address of the compilation.
   If multiple N_SO's appear, the first to contain a trailing / is the
   compilation directory.  The first to not contain a trailing / is the
   source file name, relative to the compilation directory.  Others (perhaps
   resulting from cfront) are ignored.
   On Solaris2, value is undefined, but desc is a source-language code.  */

__define_stab (N_SO, 0x64, "SO")

/* SunPro F77:  Name of alias.  */
__define_stab (N_ALIAS, 0x6c, "ALIAS")

/* Automatic variable in the stack.  Value is offset from frame pointer.
   Also used for type descriptions.  */
__define_stab (N_LSYM, 0x80, "LSYM")

/* Beginning of an include file.  Only Sun uses this.
   In an object file, only the name is significant.
   The Sun linker puts data into some of the other fields.  */
__define_stab (N_BINCL, 0x82, "BINCL")

/* Name of sub-source file (#include file).
   Value is starting text address of the compilation.  */
__define_stab (N_SOL, 0x84, "SOL")

/* Parameter variable.  Value is offset from argument pointer.
   (On most machines the argument pointer is the same as the frame pointer.  */
__define_stab (N_PSYM, 0xa0, "PSYM")

/* End of an include file.  No name.
   This and N_BINCL act as brackets around the file's output.
   In an object file, there is no significant data in this entry.
   The Sun linker puts data into some of the fields.  */
__define_stab (N_EINCL, 0xa2, "EINCL")

/* Alternate entry point.  Value is its address.  */
__define_stab (N_ENTRY, 0xa4, "ENTRY")

/* Beginning of lexical block.
   The desc is the nesting level in lexical blocks.
   The value is the address of the start of the text for the block.
   The variables declared inside the block *precede* the N_LBRAC symbol.
   On Solaris2, the value is relative to the start of the current function.  */
__define_stab (N_LBRAC, 0xc0, "LBRAC")

/* Place holder for deleted include file.  Replaces a N_BINCL and everything
   up to the corresponding N_EINCL.  The Sun linker generates these when
   it finds multiple identical copies of the symbols from an include file.
   This appears only in output from the Sun linker.  */
__define_stab (N_EXCL, 0xc2, "EXCL")

/* Modula-2 scope information.  Can someone say what info it contains?  */
__define_stab (N_SCOPE, 0xc4, "SCOPE")

/* End of a lexical block.  Desc matches the N_LBRAC's desc.
   The value is the address of the end of the text for the block.
   On Solaris2, the value is relative to the start of the current function.  */
__define_stab (N_RBRAC, 0xe0, "RBRAC")

/* Begin named common block.  Only the name is significant.  */
__define_stab (N_BCOMM, 0xe2, "BCOMM")

/* End named common block.  Only the name is significant
   (and it should match the N_BCOMM).  */
__define_stab (N_ECOMM, 0xe4, "ECOMM")

/* Member of a common block; value is offset within the common block.
   This should occur within a BCOMM/ECOMM pair.  */
__define_stab (N_ECOML, 0xe8, "ECOML")

/* Solaris2: Pascal "with" statement: type,,0,0,offset */
__define_stab (N_WITH, 0xea, "WITH")

/* These STAB's are used on Gould systems for Non-Base register symbols
   or something like that.  FIXME.  I have assigned the values at random
   since I don't have a Gould here.  Fixups from Gould folk welcome... */
__define_stab (N_NBTEXT, 0xF0, "NBTEXT")
__define_stab (N_NBDATA, 0xF2, "NBDATA")
__define_stab (N_NBBSS,  0xF4, "NBBSS")
__define_stab (N_NBSTS,  0xF6, "NBSTS")
__define_stab (N_NBLCS,  0xF8, "NBLCS")

/* Second symbol entry containing a length-value for the preceding entry.
   The value is the length.  */
__define_stab (N_LENG, 0xfe, "LENG")

/* The above information, in matrix format.

			STAB MATRIX
	_________________________________________________
	| 00 - 1F are not dbx stab symbols		|
	| In most cases, the low bit is the EXTernal bit|

	| 00 UNDEF  | 02 ABS	| 04 TEXT   | 06 DATA	|
	| 01  |EXT  | 03  |EXT	| 05  |EXT  | 07  |EXT	|

	| 08 BSS    | 0A INDR	| 0C FN_SEQ | 0E WEAKA	|
	| 09  |EXT  | 0B 	| 0D WEAKU  | 0F WEAKT	|

	| 10 WEAKD  | 12 COMM	| 14 SETA   | 16 SETT	|
	| 11 WEAKB  | 13	| 15 	    | 17	|

	| 18 SETD   | 1A SETB	| 1C SETV   | 1E WARNING|
	| 19	    | 1B	| 1D 	    | 1F FN	|

	|_______________________________________________|
	| Debug entries with bit 01 set are unused.	|
	| 20 GSYM   | 22 FNAME	| 24 FUN    | 26 STSYM	|
	| 28 LCSYM  | 2A MAIN	| 2C ROSYM  | 2E	|
	| 30 PC	    | 32 NSYMS	| 34 NOMAP  | 36	|
	| 38 OBJ    | 3A	| 3C OPT    | 3E	|
	| 40 RSYM   | 42 M2C	| 44 SLINE  | 46 DSLINE |
	| 48 BSLINE*| 4A DEFD	| 4C FLINE  | 4E	|
	| 50 EHDECL*| 52	| 54 CATCH  | 56        |
	| 58        | 5A        | 5C        | 5E	|
	| 60 SSYM   | 62 ENDM	| 64 SO	    | 66 	|
	| 68 	    | 6A	| 6C ALIAS  | 6E	|
	| 70	    | 72	| 74	    | 76	|
	| 78	    | 7A	| 7C	    | 7E	|
	| 80 LSYM   | 82 BINCL	| 84 SOL    | 86	|
	| 88	    | 8A	| 8C	    | 8E	|
	| 90	    | 92	| 94	    | 96	|
	| 98	    | 9A	| 9C	    | 9E	|
	| A0 PSYM   | A2 EINCL	| A4 ENTRY  | A6	|
	| A8	    | AA	| AC	    | AE	|
	| B0	    | B2	| B4	    | B6	|
	| B8	    | BA	| BC	    | BE	|
	| C0 LBRAC  | C2 EXCL	| C4 SCOPE  | C6	|
	| C8	    | CA	| CC	    | CE	|
	| D0	    | D2	| D4	    | D6	|
	| D8	    | DA	| DC	    | DE	|
	| E0 RBRAC  | E2 BCOMM	| E4 ECOMM  | E6	|
	| E8 ECOML  | EA WITH	| EC	    | EE	|
	| F0	    | F2	| F4	    | F6	|
	| F8	    | FA	| FC	    | FE LENG	|
	+-----------------------------------------------+
 * 50 EHDECL is also MOD2.
 * 48 BSLINE is also BROWS.
 */

  LAST_UNUSED_STAB_CODE
};

#undef __define_stab
#undef __define_stab_duplicate

#endif /* __GNU_STAB__ */
